/* sensorFunc.c - Function dealing with the sensors */

/* Includes */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "glib.h"

/* Sensor includes */
#include <sensors/sensors.h>
#include <sensors/error.h>
#include <sensors/chips.h>
#include <linux/sensors.h>

/* Prototypes */
gint getName(gchar *chipName, sensors_chip_name *name);
gint getSensorNumber(struct sensors_chip_name *name, gchar *featureName);
gint getFeature(struct sensors_chip_name *name, gint featureNumber, double *value );

gint getName(gchar *chipName, sensors_chip_name *name) {
	/* Function to fill out the sensors_chip_name struct that is
	passed to it. Returns 0 on success */

	if(sensors_parse_chip_name(chipName, name) != 0) {
		/* Error parsing chip name */
		g_print("getName - Error parsing chip name\n");
		return(1);
	}

	/* Done successfully */
	return(0);
}

gint getSensorNumber(struct sensors_chip_name *name, gchar *featureName) {
	/* Function to get the number for a sensor */
	/* Used by sensor_get_feature in the second arg */
	/* Returns the feature number on success, 0 on error */
	gint temp1=0, temp2=0;
	const sensors_feature_data *data=NULL;

	/* Parse through all the sensors for this chip */
	data = sensors_get_all_features(*name, &temp1, &temp2);
	while(data != NULL) {
		if(strcmp(data->name, featureName) == 0) {
			/* We have the feature we want */
			/* Now return the feature number */
			return(data->number);
		} else {
			data = sensors_get_all_features(*name, &temp1, &temp2);
		}
	}

	/* We didn't get anything that matched. Return 0 */
	return(0);
}

gint getFeature(struct sensors_chip_name *name, gint featureNumber, double *value ) {
	/* Function to get the actual value for a feature */
	/* Returns the value in the value arg, and 0 on success */
	
	if(sensors_get_feature(*name, featureNumber, value) != 0) {
		/* Error return 0 */
		return(1);
	}

	return(0);
}
